//***************************************
//
// DirToObj function by toadlife
//
// http://toadlife.net
//
// What: Finds the compass heading (direction) from one object to another object
//
// Initialize this fuction in your init.sqs file with this line: DirToObj = PreProcessFile "DirToObj.sqf"
//
// Call this function like so:  [object1,object2] call DirToObj (Example: [soldier1,soldier2] call DirToObj)
//
//***************************************

private ["_object1","_object2","_dir","_degree"];
_object1 = _this select 0;
_object2 = _this select 1;

// the compass heading from _object1 to _object2 is calculated here
_dir = getdir (vehicle _tracker);
_degree = ((getpos _object2 select 0) - (getpos _object1 select 0)) atan2 ((getpos _object2 select 1) - (getpos _object1 select 1));

// "_degree" is the compass heading _object1 needs to point to face _object2
if (_degree < 0) then {_degree = _degree + 360};
_degree
